<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');

require_once 'config.php';

// API Configuration
$api_key = isset($_GET['API_KEY']) ? $_GET['API_KEY'] : '';

if (empty($api_key)) {
    http_response_code(400);
    echo json_encode(["error" => "API_KEY parameter is required"]);
    exit;
}

$conn = getDBConnection();

// Find user by API_KEY
$stmt = $conn->prepare("SELECT u.*, COUNT(b.id) as total_bots 
                       FROM users u 
                       LEFT JOIN bots b ON u.id = b.user_id AND b.is_active = 1 
                       WHERE u.api_key = ? AND u.is_active = 1 
                       GROUP BY u.id");
$stmt->bind_param("s", $api_key);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $user = $result->fetch_assoc();
    
    // Get user's active bots
    $bot_stmt = $conn->prepare("SELECT bot_token, chat_id, bot_name FROM bots WHERE user_id = ? AND is_active = 1");
    $bot_stmt->bind_param("i", $user['id']);
    $bot_stmt->execute();
    $bots_result = $bot_stmt->get_result();
    
    $bots = [];
    while ($bot = $bots_result->fetch_assoc()) {
        $bots[] = $bot;
    }
    
    // Return the user data with bots
    echo json_encode([
        "status" => "success",
        "data" => [
            "USER" => $user['username'],
            "API_KEY" => $user['api_key'],
            "SUBSCRIPTION" => $user['subscription_type'],
            "ACCOUNT_EXPIRY" => $user['account_expiry'],
            "TOTAL_BOTS" => $user['total_bots'],
            "BOTS" => $bots
        ]
    ]);
    
    $bot_stmt->close();
} else {
    http_response_code(404);
    echo json_encode([
        "status" => "error",
        "message" => "Invalid API_KEY or user not found"
    ]);
}

$stmt->close();
$conn->close();
?>