<?php
// config.php
define('DB_HOST', 'localhost');
define('DB_USER', 'mafiaapi_RAD');
define('DB_PASS', 'mafiaapi_RAD');
define('DB_NAME', 'mafiaapi_RAD');

// Create connection
function getDBConnection() {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }
    
    return $conn;
}

// Create tables if they don't exist
function createTables() {
    $conn = getDBConnection();
    
    // Users table
    $users_table = "CREATE TABLE IF NOT EXISTS users (
        id INT(11) AUTO_INCREMENT PRIMARY KEY,
        username VARCHAR(100) NOT NULL UNIQUE,
        email VARCHAR(255) NOT NULL UNIQUE,
        password VARCHAR(255) NOT NULL,
        api_key VARCHAR(100) NOT NULL UNIQUE,
        subscription_type ENUM('basic', 'premium', 'enterprise') DEFAULT 'basic',
        account_expiry DATE NOT NULL,
        is_active TINYINT(1) DEFAULT 1,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )";
    
    // Bots table
    $bots_table = "CREATE TABLE IF NOT EXISTS bots (
        id INT(11) AUTO_INCREMENT PRIMARY KEY,
        user_id INT(11) NOT NULL,
        bot_token VARCHAR(255) NOT NULL,
        chat_id VARCHAR(100) NOT NULL,
        bot_name VARCHAR(100),
        is_active TINYINT(1) DEFAULT 1,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
    )";
    
    $conn->query($users_table);
    $conn->query($bots_table);
    
    $conn->close();
}

// Initialize tables
createTables();
?>